<?php
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_give_plugin', 998 );
}
function mascot_core_charitab_reg_shortcodes_give_plugin() {
	/**
     * Give Shortcode Profile Editor
     */
	vc_map( array(
		'name'     => esc_html__( 'Give Profile Editor', 'mascot-core' ),
		'base'     => 'give_profile_editor',
		'description' => esc_html__( 'Customize Profile Information', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-give',
		'params'   => array(),
		'show_settings_on_create'	=> false,
	) );


    /**
     * Give Shortcode Login
     */
	vc_map( array(
		'name'     => esc_html__( 'Give Login Form', 'mascot-core' ),
		'base'     => 'give_login',
		'description' => esc_html__( 'Front-end Login', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-give',
		'params'   => array(
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Logging Redirect", 'mascot-core' ),
				"param_name"	=> "login-redirect",
				"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
			),
		)
	) );


	/**
	 * Give Shortcode Registration
	 */
	vc_map( array(          
		'name'     => esc_html__( 'Give Registration Form', 'mascot-core' ),
		'base'     => 'give_register',
		'description' => esc_html__( 'Front-end User Registration.', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-give',
		'params'   => array(
			array(
				'type'         => 'textfield',
				'heading'      => esc_html__( 'Registration Redirect', 'mascot-core' ),
				'param_name'   => 'redirect',
				'description'  => esc_html__( 'No Default value. Insert the url of the page you want to redirect your donors to upon successful registration.', 'mascot-core' ),
			),
		),
	));

	/**
	 * Give Shortcode Form 
	 */
	vc_map( array(
		'name'		=> esc_html__( 'Give Form', 'mascot-core' ),
		'base'		=> 'give_form',
		'description' => esc_html__( 'Insert a Donation Form', 'mascot-core' ),
		'category'	=> esc_html__( 'by TM', 'mascot-core' ),
		'icon'		=> 'mascot-vc-icons vc-icon-give',
		'params'	=>array(
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Custom CSS Class", 'mascot-core' ),
				"param_name"	=> "custom_css_class",
				"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Choose Donation Form to Display", 'mascot-core' ),
				"param_name"	=> "id",
				//"description"	=> esc_html__( 'The "id" is a required attribute for this shortcode. The "id" should be the post ID of a published donation form.', 'mascot-core' ),
				'value'			=> mascot_core_charitab_get_post_list_array_by_post_type( 'give_forms', true ),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
				"param_name"	=> "show_title",
				"description"	=> esc_html__( 'Optionally show/hide the form title. Default is "Yes" which means the title will show by default.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Goal", 'mascot-core' ),
				"param_name"	=> "show_goal",
				"description"	=> esc_html__( 'Optionally show/hide the form goal, if applicable. Default is "Yes" for forms with a goal.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Display Content", 'mascot-core' ),
				"param_name"	=> "show_content",
				"description"	=> esc_html__( 'Optionally show/hide the form content. You can choose from None, Below, or Above.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Select an Option', 'mascot-core' )	=> '',
					esc_html__( 'Above', 'mascot-core' )			=> 'above',
					esc_html__( 'Below', 'mascot-core' )			=> 'below',
					esc_html__( 'None', 'mascot-core' )				=> 'none'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Display Options", 'mascot-core' ),
				"param_name"	=> "display_style",
				"description"	=> esc_html__( 'This allows you to override the method of displaying the form’s payment/additional fields.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Select an Option', 'mascot-core' )	=> '',
					esc_html__( 'On Page', 'mascot-core' )	=> 'onpage',
					esc_html__( 'Modal', 'mascot-core' )	=> 'modal',
					esc_html__( 'Reveal', 'mascot-core' )	=> 'reveal',
					esc_html__( 'Button', 'mascot-core' )	=> 'button'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Button Text", 'mascot-core' ),
				"param_name"	=> "continue_button_title",
				"description"	=> esc_html__( 'This enables the modal, button, and reveal button’s text to be customized, per shortcode.', 'mascot-core' ),
			),

		)
	));

	/**
	 * Give Shortcode Donation Form Goal 
	 */
	vc_map( array(
		'name'		=> esc_html__( 'Give Donation Form Goal', 'mascot-core' ),
		'base'		=> 'give_goal',
		'description' => esc_html__( 'Display Goal of a Donation Form', 'mascot-core' ),
		'category'	=> esc_html__( 'by TM', 'mascot-core' ),
		'icon'		=> 'mascot-vc-icons vc-icon-give',
		'params'	=>array(
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Donation Form ID", 'mascot-core' ),
				"param_name"	=> "id",
				"description"	=> esc_html__( 'The ID of the form goal you want to display.', 'mascot-core' ),
				'value'			=> mascot_core_charitab_get_post_list_array_by_post_type( 'give_forms', true ),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Text", 'mascot-core' ),
				"param_name"	=> "show_text",
				"description"	=> esc_html__( 'Displays the goal text.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Bar", 'mascot-core' ),
				"param_name"	=> "show_bar",
				"description"	=> esc_html__( 'Shows the progress bar.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'admin_label'   => true,
			),

		)
	));

	/**
	 * Give Shortcode Donation Form 
	 */
	//collect vc icon pack
	$group_icon_options = esc_html__( 'Icon Options', 'mascot-core' );
	$vc_icon_pack_array = array();
	if( function_exists('charitab_mascot_get_vc_icon_pack_array') ) {
		$vc_icon_pack_array = charitab_mascot_get_vc_icon_pack_array( array('element' => 'icon_type', 'value' => array('font-icon')), $group_icon_options );
	}
	$params_part1 = array(
		array(
			'type'			=> 'textfield',
			"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
			"param_name"	=> "custom_css_class",
			"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Stat Type", 'mascot-core' ),
			"param_name"	=> "stat_type",
			'value'			=> array(
				esc_html__( 'Show Campaign Count', 'mascot-core' )			=> 'campaign_count',
				esc_html__( 'Show Campaign Donated Amount', 'mascot-core' )	=> 'campaign_donated_amount',
				esc_html__( 'Show Campaign Donor Count', 'mascot-core' )	=> 'campaign_donor_count'
			),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Time Duration", 'mascot-core' ),
			"param_name"	=> "stat_time_duration",
			'value'			=> array(
				esc_html__( 'Today', 'mascot-core' )		=> 'today',

				esc_html__( 'This Week', 'mascot-core' )	=> 'this_week',
				esc_html__( 'Last Week', 'mascot-core' )	=> 'last_week',

				esc_html__( 'This Month', 'mascot-core' )	=> 'this_month',
				esc_html__( 'Last Month', 'mascot-core' )	=> 'last_month',

				esc_html__( 'This Quarter', 'mascot-core' )	=> 'this_quarter',
				esc_html__( 'Last Quarter', 'mascot-core' )	=> 'last_quarter',

				esc_html__( 'This Year', 'mascot-core' )	=> 'this_year',
				esc_html__( 'Last Year', 'mascot-core' )	=> 'last_year',
				//esc_html__( 'All Time', 'mascot-core' )	=> 'all_time',
			),
			'dependency'	=> array('element' => 'stat_type', 'value' => 'campaign_donated_amount'),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Stat Tag", 'mascot-core' ),
			"param_name"	=> "stat_tag",
			'description'   => esc_html__( 'Default: H3', 'mascot-core' ),
			'value'			=> mascot_core_charitab_heading_tag_list(),
			'std'			=> 'h3',
			'save_always'   => true,
			'admin_label'   => true,
		),
		
		array(
			'type'			=> 'textfield',
			"heading"		=> esc_html__( "Stat Bottom-line Text", 'mascot-core' ),
			"param_name"	=> "stat_bottomline_text",
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Text Alignment", 'mascot-core' ),
			"param_name"	=> "text_alignment",
			"description"	=> "",
			'value'			=> mascot_core_charitab_text_alignment_list(),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Type", 'mascot-core' ),
			"param_name"	=> "icon_type",
			"description"	=> "Choose font icon or image.",
			'value'			=> array(
				esc_html__( 'Font Icon', 'mascot-core' )		=> 'font-icon',
				esc_html__( 'JPG/PNG Image', 'mascot-core' )   	=> 'image'
			),
			'save_always'   => true,
			'group'			=> $group_icon_options
		),
	);

	$merged_fields = array_merge($params_part1, $vc_icon_pack_array);
	$params_part2 = array(
		array(
			'type'			=> 'attach_image',
			"heading"		=> esc_html__( "Upload Image Icon", 'mascot-core' ),
			"param_name"	=> "image_icon",
			"description"	=> esc_html__( 'Upload the custom image icon.', 'mascot-core' ),
			'group'			=> $group_icon_options,
			'dependency'	=> array('element' => 'icon_type', 'value' => 'image'),
		),
		
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Size", 'mascot-core' ),
			"param_name"	=> "icon_size",
			"description"	=> "",
			'value'			=> array(
				esc_html__( 'Default', 'mascot-core' )		=>   '',
				esc_html__( 'Small', 'mascot-core' )		=>   'icon-sm',
				esc_html__( 'Extra Small', 'mascot-core' )	=>   'icon-xs',
				esc_html__( 'Medium', 'mascot-core' )		=>   'icon-md',
				esc_html__( 'Large', 'mascot-core' )		=>   'icon-lg',
				esc_html__( 'Extra Large', 'mascot-core' )	=>   'icon-xl',
			),
			'group'			=> $group_icon_options
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Color", 'mascot-core' ),
			"param_name"	=> "icon_color",
			"description"	=> "",
			'value'			=> array(
				esc_html__( 'Default', 'mascot-core' )  => '',
				esc_html__( 'White', 'mascot-core' )	=> 'icon-white',
				esc_html__( 'Gray', 'mascot-core' )	  	=> 'icon-gray',
				esc_html__( 'Dark', 'mascot-core' )	  	=> 'icon-dark'
			),
			'group'			=> $group_icon_options,
			'save_always'   => true,
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Style", 'mascot-core' ),
			"param_name"	=> "icon_style",
			"description"	=> "",
			'value'			=> array(
				esc_html__( 'Default', 'mascot-core' )   => 'icon-default',
				esc_html__( 'Rounded', 'mascot-core' )   => 'icon-rounded',
				esc_html__( 'Circled', 'mascot-core' )   => 'icon-circled',
			),
			'group'			=> $group_icon_options
		),
		array(
			'type'			=> 'checkbox',
			"heading"		=> esc_html__( "Make Icon Area Bordered?", 'mascot-core' ),
			"param_name"	=> "icon_border_style",
			'description'   => '',
			'group'			=> $group_icon_options
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Make Icon Theme Colored?", 'mascot-core' ),
			"param_name"	=> "icon_theme_colored",
			'description'   => '',
			'value'			=> mascot_core_charitab_theme_color_list_vc(),
			'group'			=> $group_icon_options
		),
		mascot_core_charitab_vc_add_css_editor(),
	);
	$merged_fields = array_merge($merged_fields, $params_part2);

	$vc_map = array(
		'name'		=> esc_html__( 'Give Donation Stats', 'mascot-core' ),
		'base'		=> 'tmvc_give_donation_stats',
		'description' => esc_html__( 'Show Donation Stats', 'mascot-core' ),
		'category'	=> esc_html__( 'by TM', 'mascot-core' ),
		'icon'		=> 'mascot-vc-icons vc-icon-give',
		'params'	=> $merged_fields
	);
	vc_map( $vc_map );
}

add_shortcode( 'tmvc_give_donation_stats', 'mascot_core_charitab_sc_give_donation_stats' );