<?php
namespace MASCOTCORECHARITAB\Shortcodes\FunFactCounter;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_FunFact_Counter
 * @package MASCOTCORECHARITAB\Shortcodes\FunFact;
 */
class SC_FunFact_Counter implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_funfact_counter';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
			$group_icon_options = esc_html__( 'Icon Options', 'mascot-core' );
			$title_options = esc_html__( 'Title Options', 'mascot-core' );
			$counter_value_options = esc_html__( 'Counter Options', 'mascot-core' );

			//collect vc icon pack
			$vc_icon_pack_array = array();
			if( function_exists('charitab_mascot_get_vc_icon_pack_array') ) {
				$vc_icon_pack_array = charitab_mascot_get_vc_icon_pack_array( array('element' => 'icon_type', 'value' => array('font-icon')), $group_icon_options );
			}

			$params_part1 = array(
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
					"param_name"	=> "custom_css_class",
					"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					'admin_label'   => true,
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
					"param_name"	=> "design_style",
					"description"	=> "",
					'value'			=> array(
						esc_html__( "Style 1", 'mascot-core' )   => 'style1',
						esc_html__( "Style 2 -Icon Left", 'mascot-core' )   => 'style2'
					),
					'save_always'   => true,
					'admin_label'   => true,
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Title", 'mascot-core' ),
					"param_name"	=> "title",
					"description"	=> esc_html__( 'Eg: Projects Completed', 'mascot-core' ),
					'admin_label'   => true,
				),
				array(
					'type'			=> 'textarea_html',
					"heading"		=> esc_html__( "Paragraph", 'mascot-core' ),
					"param_name"	=> "content",
					'description'   => '',
					'value'			=> "Default text for Box Content. Lorem ipsum dolor sit amet, consectetur adipisicing elit.",
					'save_always'   => true,
				),


				//Icon Options
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Icon Type", 'mascot-core' ),
					"param_name"	=> "icon_type",
					"description"	=> "Choose font icon or image.",
					'value'			=> array(
						esc_html__( "Font Icon", 'mascot-core' )		=> 'font-icon',
						esc_html__( "JPG/PNG Image", 'mascot-core' )   => 'image'
					),
					'save_always'   => true,
					'group'			=> $group_icon_options
				),
			);

			$merged_fields = array_merge($params_part1, $vc_icon_pack_array);


			$params_part2 = array(
				array(
					'type'			=> 'attach_image',
					"heading"		=> esc_html__( "Upload Image Icon", 'mascot-core' ),
					"param_name"	=> "image_icon",
					"description"	=> esc_html__( 'Upload the custom image icon.', 'mascot-core' ),
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'image'),
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Icon Theme Colored?", 'mascot-core' ),
					"param_name"	=> "icon_theme_colored",
					'description'   => '',
					'value'			=> mascot_core_charitab_theme_color_list_vc(),
					'save_always'   => true,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
					'group'			=> $group_icon_options
				),
				array(
					'type'			=> 'colorpicker',
					"heading"		=> esc_html__( "Icon Custom Color", 'mascot-core' ),
					"param_name"	=> "icon_color",
					"value"		 => '',
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
				),


				//Counter Value Options
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Counter Custom CSS Class", 'mascot-core' ),
					"param_name"	=> "counter_custom_css_class",
					"description"	=> esc_html__( 'To style Counter.', 'mascot-core' ),
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Counting Value/Number", 'mascot-core' ),
					"param_name"	=> "counter_range",
					"description"	=> esc_html__( 'Enter number for counter without any special character. Default: 1250', 'mascot-core' ),
					'admin_label'   => true,
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__('Counting Value Prefix', 'mascot-core'),
					'param_name' 	=> 'counter_prefix',
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__('Counting Value Postfix', 'mascot-core'),
					'param_name' 	=> 'counter_postfix',
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Counter Duration(ms)", 'mascot-core' ),
					"param_name"	=> "counter_duration",
					"description"	=> esc_html__( 'Default: 1500', 'mascot-core' ),
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Counter Tag", 'mascot-core' ),
					"param_name"	=> "counter_tag",
					"description"	=> "",
					'value'			=> mascot_core_charitab_heading_tag_list(),
					'std'			=> 'h2',
					'admin_label'   => true,
					'save_always'   => true,
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Counter Text Theme Colored?", 'mascot-core' ),
					"param_name"	=> "counter_theme_colored",
					'description'   => '',
					'value'			=> mascot_core_charitab_theme_color_list_vc(),
					'save_always'   => true,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'colorpicker',
					"heading"		=> esc_html__( "Counter Text Custom Color", 'mascot-core' ),
					"param_name"	=> "counter_text_color",
					"value"		 => '',
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
					"param_name"	=> "counter_font_size",
					"description"	=> "",
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
					"param_name"	=> "counter_line_height",
					"description"	=> "",
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
					"param_name"	=> "counter_letter_spacing",
					"description"	=> "",
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
					"param_name"	=> "counter_font_style",
					"description"	=> "",
					'value'			=> mascot_core_charitab_vc_font_style_list(),
					'group'			=> $counter_value_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
					"param_name"	=> "counter_font_weight",
					"description"	=> "",
					'value'			=> mascot_core_charitab_vc_font_weight_list(),
					'group'			=> $counter_value_options
				),


				//Title Options
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Title Custom CSS Class", 'mascot-core' ),
					"param_name"	=> "title_custom_css_class",
					"description"	=> esc_html__( 'To style Title.', 'mascot-core' ),
					'group'			=> $title_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
					"param_name"	=> "title_tag",
					"description"	=> "",
					'value'			=> mascot_core_charitab_heading_tag_list(),
					'std'			=> 'h4',
					'admin_label'   => true,
					'save_always'   => true,
					'group'			=> $title_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Title Text Theme Colored?", 'mascot-core' ),
					"param_name"	=> "title_theme_colored",
					'description'   => '',
					'value'			=> mascot_core_charitab_theme_color_list_vc(),
					'save_always'   => true,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
					'group'			=> $title_options
				),
				array(
					'type'			=> 'colorpicker',
					"heading"		=> esc_html__( "Title Text Custom Color", 'mascot-core' ),
					"param_name"	=> "title_text_color",
					"value"		 => '',
					'group'			=> $title_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
					"param_name"	=> "title_font_size",
					"description"	=> "",
					'group'			=> $title_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
					"param_name"	=> "title_line_height",
					"description"	=> "",
					'group'			=> $title_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
					"param_name"	=> "title_letter_spacing",
					"description"	=> "",
					'group'			=> $title_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
					"param_name"	=> "title_font_style",
					"description"	=> "",
					'value'			=> mascot_core_charitab_vc_font_style_list(),
					'group'			=> $title_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
					"param_name"	=> "title_font_weight",
					"description"	=> "",
					'value'			=> mascot_core_charitab_vc_font_weight_list(),
					'group'			=> $title_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
					"param_name"	=> "title_text_transform",
					"description"	=> "",
					'value'			=> mascot_core_charitab_vc_text_transform_list(),
					'group'			=> $title_options
				),






				//Content Options
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Text Alignment", 'mascot-core' ),
					"param_name"	=> "text_alignment",
					"description"	=> "",
					'value'			=> mascot_core_charitab_text_alignment_list(),
					'group'			=> $group_content_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Icon/Image", 'mascot-core' ),
					"param_name"	=> "show_icon_image",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'group'			=> $group_content_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Counter", 'mascot-core' ),
					"param_name"	=> "show_counter",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'group'			=> $group_content_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
					"param_name"	=> "show_title",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'group'			=> $group_content_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Show Paragraph", 'mascot-core' ),
					"param_name"	=> "show_paragraph",
					'description'   => '',
					'value'			=> array(
						esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						esc_html__( 'No', 'mascot-core' )	=> 'false'
					),
					'group'			=> $group_content_options
				),



			);

			$merged_fields = array_merge($merged_fields, $params_part2);

			$vc_map = array(
				'name'		=> esc_html__( 'Fun Fact Counter', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-funfact',
				'allowed_container_element' => 'vc_row',
				'params'	=> $merged_fields
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_funfact_counter_vc_map_modifier') ) {
				mascot_core_charitab_sc_funfact_counter_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_funfact_counter_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_funfact_counter_render( $attr, $content );
		}
		
	}
}