<?php
namespace MASCOTCORECHARITAB\Shortcodes\CustomColumnsHolder;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Custom_Columns_Holder
 * @package MASCOTCORECHARITAB\Shortcodes\CustomColumnsHolder;
 */
class SC_Custom_Columns_Holder implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_custom_columns_holder';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
    
		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Custom Columns Holder', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-custom-columns-holder',
				'as_parent' => array('only' => 'tm_custom_columns_holder_item'),
				"js_view" => 'VcColumnView',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					mascot_core_charitab_row_typography(),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns", 'mascot-core' ),
						"param_name"	=> "number_of_columns",
						'description'   => '',
						'value'			=> array(
							esc_html__( '1 Column', 'mascot-core' )		=> 'one-column',
							esc_html__( '2 Columns', 'mascot-core' )	=> 'two-columns',
							esc_html__( '3 Columns', 'mascot-core' )	=> 'three-columns',
							esc_html__( '4 Columns', 'mascot-core' )	=> 'four-columns',
							esc_html__( '5 Columns', 'mascot-core' )	=> 'five-columns',
							esc_html__( '6 Columns', 'mascot-core' )	=> 'six-columns',
						),
						'admin_label'   => true,
						'save_always'   => true,
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Items Float Left", 'mascot-core' ),
						"param_name"	=> "items_float_left",
						'value'			=> array( esc_html__('Make Items Float Left?', 'mascot-core') => 'yes' ),
						'admin_label'   => true,
					),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Switch to One Column", 'mascot-core' ),
						"param_name"	=> "switch_to_one_column",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Default', 'mascot-core' )			=> '',
							esc_html__( 'Below 1280px', 'mascot-core' )		=> '1280',
							esc_html__( 'Below 1024px', 'mascot-core' )		=> '1024',
							esc_html__( 'Below 768px', 'mascot-core' )		=> '768',
							esc_html__( 'Below 600px', 'mascot-core' )		=> '600',
							esc_html__( 'Below 480px', 'mascot-core' )		=> '480',
							esc_html__( 'Never', 'mascot-core' )			=> 'never',
						),
						"description"	=> esc_html__( 'Choose on which stage item will be in one column.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Choose Alignment In Responsive Mode", 'mascot-core' ),
						"param_name"	=> "alignment_one_column",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Default', 'mascot-core' )		=> '',
							esc_html__( 'Left', 'mascot-core' )			=> 'left',
							esc_html__( 'Center', 'mascot-core' )		=> 'center',
							esc_html__( 'Right', 'mascot-core' )		=> 'right',
						),
						"description"	=> esc_html__( 'Alignment When Items are in One Column.', 'mascot-core' ),
						'admin_label'   => true,
					),


					
					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_custom_columns_holder_vc_map_modifier') ) {
				mascot_core_charitab_sc_custom_columns_holder_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_custom_columns_holder_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_custom_columns_holder_render( $attr, $content );
		}
		
	}
}