<?php
namespace MASCOTCORECHARITAB\Shortcodes\CustomColumnsHolderItem;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Custom_Columns_Holder_Item
 * @package MASCOTCORECHARITAB\Shortcodes\CustomColumnsHolderItem;
 */
class SC_Custom_Columns_Holder_Item implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_custom_columns_holder_item';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Custom Columns Holder Item', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-custom-columns-holder-item',
				'as_child' => array('only' => 'tm_custom_columns_holder'),
				'as_parent' => array('except' => 'vc_accordion'),
				'content_element' => true,
				'show_settings_on_create' => true,
				"js_view" => 'VcColumnView',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					
					mascot_core_charitab_row_typography(),
					
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Padding", 'mascot-core' ),
						"param_name"	=> "item_padding",
						"description"	=> esc_html__( 'Please insert padding in format 0px 10px 0px 10px.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Horizontal Alignment", 'mascot-core' ),
						"param_name"	=> "horizontal_aligment",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Left', 'mascot-core' )			=> 'left',
							esc_html__( 'Center', 'mascot-core' )		=> 'center',
							esc_html__( 'Right', 'mascot-core' )		=> 'right',
						),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Vertical Alignment", 'mascot-core' ),
						"param_name"	=> "vertical_alignment",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Middle', 'mascot-core' )	=> 'middle',
							esc_html__( 'Top', 'mascot-core' )		=> 'top',
							esc_html__( 'Bottom', 'mascot-core' )	=> 'bottom',
						),
						'admin_label'   => true,
					),


					array(
						'type'        => 'textfield',
						'heading'     => esc_html__('Link', 'mascot-core'),
						'param_name'  => 'link',
						'group'		  => esc_html__('Link', 'mascot-core'),
						'admin_label' => true
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__('Link Target', 'mascot-core'),
						'param_name'  => 'target',
						'group'		  => esc_html__('Link', 'mascot-core'),
						'value'       => array(
							'Self'  => '_self',
							'Blank' => '_blank'
						),
						'save_always' => true,
						'admin_label' => true
					),



					//media-breakpoint-down
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Down - Padding on Large devices (desktops, less than 1200px)','mascot-core'),
						'param_name' => 'item_padding_1199_down',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Down - Padding on Medium devices (tablets, less than 992px)','mascot-core'),
						'param_name' => 'item_padding_991_down',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Down - Padding on Small devices (landscape phones, less than 768px)','mascot-core'),
						'param_name' => 'item_padding_767_down',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Down - Padding on Extra small devices (portrait phones, less than 576px)','mascot-core'),
						'param_name' => 'item_padding_575_down',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),



					//media-breakpoint-only
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Between - Padding on Large devices (desktops, 992px to 1199.98px)','mascot-core'),
						'param_name' => 'item_padding_992_to_1199',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Between - Padding on Medium devices (tablets, 768px to 991.98px)','mascot-core'),
						'param_name' => 'item_padding_768_to_991',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Between - Padding on Small devices (landscape phones, 576px to 767.98px)','mascot-core'),
						'param_name' => 'item_padding_576_to_767',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),



					//media-breakpoint-up
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Up - Padding on Extra large devices (large desktops, 1200px and up)','mascot-core'),
						'param_name' => 'item_padding_1200_up',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Up - Padding on Large devices (desktops, 992px and up)','mascot-core'),
						'param_name' => 'item_padding_992_up',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Up - Padding on Medium devices (tablets, 768px and up)','mascot-core'),
						'param_name' => 'item_padding_768_up',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					array(
						'type' => 'textfield',
						'class' => '',
						'group' => esc_html__('Width & Responsiveness','mascot-core'),
						'heading' => esc_html__('Up - Padding on Small devices (landscape phones, 576px and up)','mascot-core'),
						'param_name' => 'item_padding_576_up',
						'value' => '',
						'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'mascot-core')
					),
					
					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_custom_columns_holder_item_vc_map_modifier') ) {
				mascot_core_charitab_sc_custom_columns_holder_item_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_custom_columns_holder_item_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_custom_columns_holder_item_render( $attr, $content );
		}
		
	}
}