<?php
namespace MASCOTCORECHARITAB\Shortcodes\CountdownTimer;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Countdown_Timer
 * @package MASCOTCORECHARITAB\Shortcodes\CountdownTimer;
 */
class SC_Countdown_Timer implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_countdown_timer';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
			$group_word_options = esc_html__( 'Word Options', 'mascot-core' );
			$group_modern_circular_options = esc_html__( 'Modern Circular Options', 'mascot-core' );

			$vc_map = array(
				'name'		=> esc_html__( 'Countdown Timer', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-countdown-timer',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Final Countdown - Smart Version", 'mascot-core' )	=> 'final-countdown-smart-style',
							esc_html__( "Final Countdown - Modern Circular", 'mascot-core' )	=> 'final-countdown-modern-circular',
							esc_html__( "Final Countdown - Advanced Coupon", 'mascot-core' )	=> 'final-countdown-advanced-coupon',
							esc_html__( "Final Countdown - Basic Coupon", 'mascot-core' )	=> 'final-countdown-basic-coupon',
							esc_html__( "Final Countdown - Legacy style", 'mascot-core' )	=> 'final-countdown-legacy-style',
							esc_html__( "Final Countdown - Months + Days", 'mascot-core' )	=> 'final-countdown-months-offsets',
							esc_html__( "Final Countdown - Weeks + Days", 'mascot-core' )	=> 'final-countdown-weeks-offsets',
							esc_html__( "Final Countdown - Only Days", 'mascot-core' )		=> 'final-countdown-days-offsets',
							esc_html__( "Final Countdown - Only Hours", 'mascot-core' )		=> 'final-countdown-hours',
						),
						'save_always'	=> true,
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Future Ending Date & Time (Format Y/m/d H:i:s)", 'mascot-core' ),
						"param_name"	=> "countdown_future_date_time",
						"std"			=> date("Y/m/d H:i:s", strtotime("+5 week")),
						"description"	=> sprintf( esc_html__( 'See documentation from %1$shere%2$s to format a local time/date.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://www.php.net/manual/en/function.date.php' ) . '">', '</a>' ),
						'save_always'	=> true,
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Timezone", 'mascot-core' ),
						"param_name"	=> "timezone",
						"description"	=> sprintf( esc_html__( 'Example: Europe/Zurich. Get your own timezone from %1$shere%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://php.net/manual/en/timezones.php' ) . '">', '</a>' ),
						'dependency'	=> array('element' => 'design_style', 'value' => 'final-countdown-modern-circular'),
						'group'			=> $group_modern_circular_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Circle Border Width", 'mascot-core' ),
						"param_name"	=> "borderwidth",
						"value"		 	=> '3',
						'dependency'	=> array('element' => 'design_style', 'value' => 'final-countdown-modern-circular'),
						'group'			=> $group_modern_circular_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Second Border Color", 'mascot-core' ),
						"param_name"	=> "bordercolor_second",
						"value"		 	=> '#7995D5',
						'dependency'	=> array('element' => 'design_style', 'value' => 'final-countdown-modern-circular'),
						'group'			=> $group_modern_circular_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Minutes Border Color", 'mascot-core' ),
						"param_name"	=> "bordercolor_minutes",
						"value"		 	=> '#ACC742',
						'dependency'	=> array('element' => 'design_style', 'value' => 'final-countdown-modern-circular'),
						'group'			=> $group_modern_circular_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Hours Border Color", 'mascot-core' ),
						"param_name"	=> "bordercolor_hours",
						"value"		 	=> '#ECEFCB',
						'dependency'	=> array('element' => 'design_style', 'value' => 'final-countdown-modern-circular'),
						'group'			=> $group_modern_circular_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Days Border Color", 'mascot-core' ),
						"param_name"	=> "bordercolor_days",
						"value"		 	=> '#FF9900',
						'dependency'	=> array('element' => 'design_style', 'value' => 'final-countdown-modern-circular'),
						'group'			=> $group_modern_circular_options
					),








					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Show Time?", 'mascot-core' ),
						"param_name"	=> "show_time",
						"description"	=> esc_html__( 'Show or Hide Time of the date', 'mascot-core' ),
						"std"			=> 'true',
					),


					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Word - Month", 'mascot-core' ),
						"param_name"	=> "word_month",
						"std"		=> esc_html__( "months", 'mascot-core' ),
						'group'			=> $group_word_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Word - Week", 'mascot-core' ),
						"param_name"	=> "word_week",
						"std"		=> esc_html__( "weeks", 'mascot-core' ),
						'group'			=> $group_word_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Word - Day", 'mascot-core' ),
						"param_name"	=> "word_day",
						"std"		=> esc_html__( "days", 'mascot-core' ),
						'group'			=> $group_word_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Word - Hour", 'mascot-core' ),
						"param_name"	=> "word_hr",
						"std"		=> esc_html__( "hr", 'mascot-core' ),
						'group'			=> $group_word_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Word - Minute", 'mascot-core' ),
						"param_name"	=> "word_min",
						"std"		=> esc_html__( "min", 'mascot-core' ),
						'group'			=> $group_word_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Word - Second", 'mascot-core' ),
						"param_name"	=> "word_sec",
						"std"		=> esc_html__( "sec", 'mascot-core' ),
						'group'			=> $group_word_options
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_countdown_timer_vc_map_modifier') ) {
				mascot_core_charitab_sc_countdown_timer_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_countdown_timer_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_countdown_timer_render( $attr, $content );
		}
		
	}
}