<?php

if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_works', 998 );
}
function mascot_core_charitab_reg_shortcodes_works() {
	vc_map( array(
		'name'     => esc_html__( 'Work Title', 'mascot-core' ),
		'base'     => 'tmvc_works_title',
		'description' => esc_html__( 'Works', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_works_title extends WPBakeryShortCode {
	}


	
	vc_map( array(
		'name'     => esc_html__( 'Work Thumb', 'mascot-core' ),
		'base'     => 'tmvc_works_thumb',
		'description' => esc_html__( 'Works', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
				"param_name"	=> "thumb_image_size",
				'description'   => '',
				'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
				'std'			=> 'charitab_mascot_square',
				'admin_label'   => true,
			),
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_works_thumb extends WPBakeryShortCode {
	}


	$group_button_options = esc_html__( 'Button Options', 'mascot-core' );
	$group_query_options = esc_html__( 'Query Options', 'mascot-core' );
	$categories_array = mascot_core_charitab_category_list_array_for_vc( 'works_category' );
	$orderby_parameters_list = mascot_core_charitab_category_orderby_parameters_list();
	
	vc_map( array(
		'name'     => esc_html__( 'Work Categories', 'mascot-core' ),
		'base'     => 'tmvc_works_categories',
		'description' => esc_html__( 'Works', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-works',
		'params'   => array(
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
				"param_name"	=> "design_style",
				"description"	=> "",
				'value'			=> array(
					esc_html__( 'Default', 'mascot-core' )	=> 'style-default',
					esc_html__( 'Floating Text On Image', 'mascot-core' )	=> 'style-floating',
					esc_html__( 'Hanging Below Image', 'mascot-core' )	=> 'style-hanging'
				),
				'save_always'   => true,
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
				"param_name"	=> "thumb_image_size",
				'description'   => '',
				'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
				'std'			=> 'charitab_mascot_square',
				'admin_label'   => true,
			),



			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
				"param_name"	=> "show_title",
				'description'   => '',
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Excerpt", 'mascot-core' ),
				"param_name"	=> "show_excerpt",
				'description'   => '',
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Excerpt Length", 'mascot-core' ),
				"param_name"	=> "excerpt_length",
				"description"	=> esc_html__( 'Number of words to display. Example: 25. Default all.', 'mascot-core' ),
				'dependency'	=> array('element' => 'show_excerpt', 'value' => 'true'),
			),




			array(
				'type'			=> 'checkbox',
				"heading"		=> esc_html__( "Categories to Display", 'mascot-core' ),
				"param_name"	=> "selected_category",
				"description"	=> esc_html__( 'Choose categories to display.', 'mascot-core' ),
				'value'			=> $categories_array,
				'group'			=> $group_query_options
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Order By", 'mascot-core' ),
				"param_name"	=> "order_by",
				"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
				'value'			=> $orderby_parameters_list,
				'std'			=> $orderby_parameters_list['name'],
				'group'			=> $group_query_options
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Order", 'mascot-core' ),
				"param_name"	=> "order",
				"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
					esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
				),
				'group'			=> $group_query_options
			),




			//Button
			mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
			mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

			//Button options
			mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
			mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),
			
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_works_categories extends WPBakeryShortCode {
	}

}