<?php
namespace MASCOTCORECHARITAB\CPT\VCSidebars\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\VCSidebars\CPT_VC_Sidebars;

/**
 * class SC_VC_Sidebars
 * @package MASCOTCORECHARITAB\CPT\VCSidebars\Shortcodes;
 */
class SC_VC_Sidebars implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->base = 'tmvc_vcsidebars';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$new_cpt_class = CPT_VC_Sidebars::Instance();
			$available_sidebars_array = get_posts( array( 'post_type' => $new_cpt_class->ptKey, 'posts_per_page' => - 1 ) );
			$available_sidebars = array( esc_html__( 'Select', 'mascot-core' ) => 0 );
			if ( $available_sidebars_array && ! is_wp_error( $available_sidebars_array ) ) {
				foreach ( $available_sidebars_array as $val ) {
					$available_sidebars[ get_the_title( $val ) ] = $val->ID;
				}
			}


			$vc_map = array(
				'name'		=> esc_html__( 'VC Sidebars', 'mascot-core' ),
				'base'		=> $this->base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-vcsidebar',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Choose Sidebar", 'mascot-core' ),
						"param_name"	=> "sidebar",
						"value"			=> $available_sidebars,
						'admin_label'   => true,
						'save_always'   => true,
					),
					mascot_core_charitab_vc_add_css_editor(),
				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_vc_sidebars_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_vc_sidebars_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_vc_sidebars_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_vc_sidebars_render( $attr, $content, CPT_VC_Sidebars::Instance() );
		}
		
	}
}