<?php
namespace MASCOTCORECHARITAB\CPT\Vacancies\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\Vacancies\CPT_Vacancies;

/**
 * class SC_Vacancies
 * @package MASCOTCORECHARITAB\CPT\Vacancies\Shortcodes;
 */
class SC_Vacancies implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		/*if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-vacancies-enable', true ) ) {
				return;
			}
		}*/
		$this->base = 'tmvc_vacancies';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content', 'mascot-core' );
			$group_carousel_options = esc_html__( 'Carousel', 'mascot-core' );
			$group_query_options = esc_html__( 'Query', 'mascot-core' );
			$new_cpt_class = CPT_Vacancies::Instance();
			$categories_array = mascot_core_charitab_category_list_array_for_vc( $new_cpt_class->ptTaxKey );

			$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();


			$vc_map = array(
				'name'		=> esc_html__( 'Vacancy list', 'mascot-core' ),
				'base'		=>$this->base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-vacancy',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					//Query Options
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "selected_category",
						"description"	=> esc_html__( 'Choose a category to pull vacancies from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),

					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_vacancies_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_vacancies_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		/*if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-vacancies-enable', true ) ) {
				return;
			}
		}*/

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_vacancies_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_vacancies_render( $attr, $content, CPT_Vacancies::Instance() );
		}
		
	}
}