<?php
namespace MASCOTCORECHARITAB\CPT\Portfolio\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\Portfolio\CPT_Portfolio;

/**
 * class SC_Portfolio
 * @package MASCOTCORECHARITAB\CPT\Portfolio\Shortcodes;
 */
class SC_Portfolio implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-portfolio-enable', true ) ) {
				return;
			}
		}
		$this->base = 'tmvc_portfolio';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
			$group_carousel_options = esc_html__( 'Carousel Options', 'mascot-core' );
			$group_query_options = esc_html__( 'Query Options', 'mascot-core' );
			$new_cpt_class = CPT_Portfolio::Instance();
			$categories_array = mascot_core_charitab_category_list_array_for_vc( $new_cpt_class->ptTaxKey );

			$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();


			$vc_map = array(
				'name'		=> esc_html__( 'Portfolio', 'mascot-core' ),
				'base'		=>$this->base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Portfolio Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-tm',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )		=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )	=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )	=> 'carousel'
						),
						'save_always'	=> true,
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Image Orientation", 'mascot-core' ),
						"param_name"	=> "portfolio_image_orientation",
						"description"	=> "",
						'value'			=> array(
							'Landscape View' => 'landscape',
							'Portrait View'  => 'portrait'
						),
						'save_always'	=> true,
						'admin_label'	=> true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Image Aspect Ratio", 'mascot-core' ),
						"param_name"	=> "portfolio_image_aspect_ratio",
						"description"	=> esc_html__( 'Define Aspect Ratio for Portfolio Images.', 'mascot-core' ),
						'value'			=> array(
							'16:9'  =>  '16:9',
							'4:3'	=>  '4:3',
							'3:2'	=>  '3:2',
							'1:1'	=>  '1:1',
						),
						'std'			=> 4,
						'admin_label'	=> true,
					),



					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "selected_category",
						"description"	=> esc_html__( 'Choose a category to pull portfolio from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),
					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Gutter", 'mascot-core' ),
						"param_name"	=> "gutter",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> mascot_core_charitab_portfolio_gutter_list(),
						'save_always'	=> true,
						'admin_label'	=> true,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry')),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Hover Effect", 'mascot-core' ),
						"param_name"	=> "portfolio_hover_effect",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Default', 'mascot-core' )			=> '',
							esc_html__( 'Effect Simple', 'mascot-core' )	=> 'effect-simple',
							esc_html__( 'Effect Standard', 'mascot-core' )	=> 'effect-standard',
							esc_html__( 'Effect London', 'mascot-core' )	=> 'effect-london',
							esc_html__( 'Effect Rome', 'mascot-core' )		=> 'effect-rome',
							esc_html__( 'Effect Paris', 'mascot-core' )		=> 'effect-paris',
							esc_html__( 'Effect Barlin', 'mascot-core' )	=> 'effect-barlin',
						),
						'save_always'	=> true,
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Overlay Color on Image", 'mascot-core' ),
						"param_name"	=> "portfolio_overlay_color_on_image",
						"description"	=> "",
						'value'			=> array(
							'Black Ovedrlay' => '',
							'White Ovedrlay'  => 'shade-white'
						),
						'save_always'	=> true,
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Add Gradient Effect on Image", 'mascot-core' ),
						"param_name"	=> "show_gradient_effect_on_image",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'std'			=> 'false',
						'save_always'	=> true,
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Filter", 'mascot-core' ),
						"param_name"	=> "show_portfolio_filter",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'	=> true,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry')),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
						"param_name"	=> "show_portfolio_title",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Overlay Zoom/Link Icons", 'mascot-core' ),
						"param_name"	=> "show_portfolio_overlay_zoomlink_icons",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Description", 'mascot-core' ),
						"param_name"	=> "show_portfolio_description",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'std'			=> 'false',
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Date", 'mascot-core' ),
						"param_name"	=> "show_portfolio_date",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'std'			=> 'false',
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Category", 'mascot-core' ),
						"param_name"	=> "show_selected_category",
						'description'	=> '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'	=> true,
						'group'			=> $group_content_options
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_portfolio_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_portfolio_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-portfolio-enable', true ) ) {
				return;
			}
		}

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_portfolio_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_portfolio_render( $attr, $content, CPT_Portfolio::Instance() );
		}
		
	}
}