<?php
namespace MASCOTCORECHARITAB\CPT\Partners\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\Partners\CPT_Partners;

/**
 * class SC_Partners
 * @package MASCOTCORECHARITAB\CPT\Partners\Shortcodes;
 */
class SC_Partners implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-partners-enable', true ) ) {
				return;
			}
		}
		$this->base = 'tmvc_partners';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}



	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content', 'mascot-core' );
			$group_carousel_options = esc_html__( 'Carousel', 'mascot-core' );
			$group_query_options = esc_html__( 'Query', 'mascot-core' );
			$group_button_options = esc_html__( 'Button', 'mascot-core' );
			$group_loadmore_button_options = esc_html__( 'Loadmore Button', 'mascot-core' );
			$group_appointement_button_options = esc_html__( 'Appointment Button', 'mascot-core' );
			$new_cpt_class = CPT_Partners::Instance();
			$categories_array = mascot_core_charitab_category_list_array_for_vc( $new_cpt_class->ptTaxKey );

			$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();


			$vc_map = array(
				'name'		=> esc_html__( 'Partners', 'mascot-core' ),
				'base'		=>$this->base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Partners Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-partners',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Style 1 - Default', 'mascot-core' )	=> 'partners-style1-simple',
							esc_html__( 'Style 2 - Classic', 'mascot-core' )	=> 'partners-style2-classic',
							esc_html__( 'Style 3 - Modern', 'mascot-core' )		=> 'partners-style3-modern',
							esc_html__( 'Style 4 - Everything Centered', 'mascot-core' )	=> 'partners-style4-everything-centered',
							esc_html__( 'Style 5 - Current Theme', 'mascot-core' )	=> 'partners-style5-current-theme',
							esc_html__( 'Style 6 - Horizontal', 'mascot-core' )	=> 'partners-style6-horizontal',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )		=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )	=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )	=> 'carousel'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'admin_label'   => true,
					),



					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "selected_category",
						"description"	=> esc_html__( 'Choose a category to pull partners from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),
					

					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
						"param_name"	=> "feature_thumb_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'post-thumbnail',
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Content Area", 'mascot-core' ),
						"param_name"	=> "show_content_area",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Name", 'mascot-core' ),
						"param_name"	=> "show_name",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Speciality", 'mascot-core' ),
						"param_name"	=> "show_speciality",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Short Bio", 'mascot-core' ),
						"param_name"	=> "show_short_bio",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Short Bio Length", 'mascot-core' ),
						"param_name"	=> "excerpt_length",
						"description"	=> esc_html__( 'Number of words to display. Example: 25. Default all.', 'mascot-core' ),
						'dependency'	=> array('element' => 'show_short_bio', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Contact Info", 'mascot-core' ),
						"param_name"	=> "show_contact_info",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'No', 'mascot-core' )	=> 'false',
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						),
						'std'			=> 'false',
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Appointment Button", 'mascot-core' ),
						"param_name"	=> "show_appointment_btn",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'No', 'mascot-core' )	=> 'false',
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						),
						'std'			=> 'false',
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Working Hours", 'mascot-core' ),
						"param_name"	=> "show_working_hours",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'No', 'mascot-core' )	=> 'false',
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						),
						'std'			=> 'false',
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Social Link", 'mascot-core' ),
						"param_name"	=> "show_social_link",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),





					

					
					//Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

					//Button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

					//Loadmore Button options
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					$array = array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Loading Text", 'mascot-core' ),
						"param_name"	=> "loadmore_button_loading_text",
						'std'			=> esc_html__( "Loading...", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $group_loadmore_button_options
					),
					mascot_core_charitab_get_button_arraylist( 1, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_loadmore_button_options, 'loadmore_' ),

					//Appointment Button options
					mascot_core_charitab_get_button_arraylist( 1, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_appointement_button_options, 'appointment_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_appointement_button_options, 'appointment_' ),

					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_partners_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_partners_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-partners-enable', true ) ) {
				return;
			}
		}

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_partners_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_partners_render( $attr, $content, CPT_Partners::Instance() );
		}
		
	}
}