<?php
use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\Gallery\CPT_Gallery;
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_gallery_single_post', 998 );
}
function mascot_core_charitab_reg_shortcodes_gallery_single_post() {
	$new_cpt_class = CPT_Gallery::Instance();
	$available_posts_array = get_posts( array( 'post_type' => $new_cpt_class->ptKey, 'posts_per_page' => - 1 ) );
	$available_posts = array( esc_html__( 'Select', 'mascot-core' ) => 0 );
	if ( $available_posts_array && ! is_wp_error( $available_posts_array ) ) {
		foreach ( $available_posts_array as $val ) {
			$available_posts[ get_the_title( $val ) ] = $val->ID;
		}
	}
	$group_content_options = esc_html__( 'Content', 'mascot-core' );

	vc_map( array(
		'name'     => esc_html__( 'Gallery Single Post', 'mascot-core' ),
		'base'     => 'tmvc_gallery_single_post',
		'description' => esc_html__( 'Gallery', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-gallery',
		'params'   => array(
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
				"param_name"	=> "custom_css_class",
				"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Choose Gallery Post to Display", 'mascot-core' ),
				"param_name"	=> "gallery_single_id",
				"value"			=> $available_posts,
				'admin_label'   => true,
				'save_always'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
				"param_name"	=> "thumb_image_size",
				'description'   => '',
				'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
				'std'			=> 'charitab_mascot_square',
				'admin_label'   => true,
				'save_always'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
				"param_name"	=> "columns",
				"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
				'value'			=> array(
					'1'  =>  '1',
					'2'  =>  '2',
					'3'  =>  '3',
					'4'  =>  '4',
					'5'  =>  '5',
					'6'  =>  '6',
					'7'  =>  '7',
					'8'  =>  '8',
					'9'  =>  '9',
					'10'  =>  '10',
				),
				'std'			=> 4,
				'admin_label'   => true,
				'save_always'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Gutter", 'mascot-core' ),
				"param_name"	=> "gutter",
				'value'			=> mascot_core_charitab_portfolio_gutter_list(),
				'save_always'   => true,
				'admin_label'   => true,
				'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry')),
				'group'			=> $group_content_options
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Overlay Color on Image", 'mascot-core' ),
				"param_name"	=> "gallery_overlay_color_on_image",
				"description"	=> "",
				'value'			=> array(
					'Theme Color 1 Ovedrlay'	=> 'shade-theme-colored1',
					'Theme Color 2 Ovedrlay'	=> 'shade-theme-colored2',
					'Black Ovedrlay'			=> 'shade-black',
					'White Ovedrlay'			=> 'shade-white',
				),
				'save_always'   => true,
				'group'			=> $group_content_options
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Add Gradient Effect on Image", 'mascot-core' ),
				"param_name"	=> "show_gradient_effect_on_image",
				'description'   => '',
				'value'			=> array(
					esc_html__( 'No', 'mascot-core' )	=> 'false',
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
				),
				'std'			=> 'false',
				'save_always'   => true,
				'group'			=> $group_content_options
			),
		)
	) );
	class WPBakeryShortCode_tmvc_gallery_single_post extends WPBakeryShortCode {
	}
}