<?php
namespace MASCOTCORECHARITAB\CPT\FAQ\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\FAQ\CPT_FAQ;

/**
 * class SC_FAQ
 * @package MASCOTCORECHARITAB\CPT\FAQ\Shortcodes;
 */
class SC_FAQ implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-faq-enable', true ) ) {
				return;
			}
		}
		$this->base = 'tmvc_faq';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$group_query_options = esc_html__( 'Query Options', 'mascot-core' );
			$new_cpt_class = CPT_FAQ::Instance();
			$categories_array = mascot_core_charitab_category_list_array_for_vc( $new_cpt_class->ptTaxKey );

			$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();


			$vc_map = array(
				'name'		=> esc_html__( 'FAQ', 'mascot-core' ),
				'base'		=>$this->base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'FAQ List/Accordion', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-faq',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Style 1 - List Group", 'mascot-core' )			  	=> 'style1-listgroup',
							esc_html__( "Style 2 - Accordion", 'mascot-core' )				=> 'style2-accordion',
							esc_html__( "Style 3 - Accordion Transparent", 'mascot-core' )  => 'style3-accordion-transparent',
							esc_html__( "Style 4 - Scroll to Fixed", 'mascot-core' )		=> 'style4-scrolltofixed'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "selected_category",
						"description"	=> esc_html__( 'Choose a category to pull features from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_faq_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_faq_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-faq-enable', true ) ) {
				return;
			}
		}

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_faq_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_faq_render( $attr, $content, CPT_FAQ::Instance() );
		}
		
	}
}